<?php
/**
 * Related posts based on categories and tags.
 * 
 */

$fashion_designer_related_posts_taxonomy = get_theme_mod( 'fashion_designer_related_posts_taxonomy', 'category' );

$fashion_designer_post_args = array(
    'posts_per_page'    => absint( get_theme_mod( 'fashion_designer_related_posts_count', '3' ) ),
    'orderby'           => 'rand',
    'post__not_in'      => array( get_the_ID() ),
);

$fashion_designer_tax_terms = wp_get_post_terms( get_the_ID(), 'category' );
$fashion_designer_terms_ids = array();
foreach( $fashion_designer_tax_terms as $tax_term ) {
	$fashion_designer_terms_ids[] = $tax_term->term_id;
}

$fashion_designer_post_args['category__in'] = $fashion_designer_terms_ids; 

if(get_theme_mod('fashion_designer_related_post',true)==1){

$fashion_designer_related_posts = new WP_Query( $fashion_designer_post_args );

if ( $fashion_designer_related_posts->have_posts() ) : ?>
    <div class="related-post">
        <h3><?php echo esc_html(get_theme_mod('fashion_designer_related_post_title','Related Post'));?></h3>
        <div class="row">
            <?php while ( $fashion_designer_related_posts->have_posts() ) : $fashion_designer_related_posts->the_post(); ?>
                <?php get_template_part('template-parts/grid-layout'); ?>
            <?php endwhile; ?>
        </div>
    </div>
<?php endif;
wp_reset_postdata();

}