<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Craftsys\Msg91\Facade\Msg91;
use App\Models\User;
use Validator;

class Login extends Controller
{
    function loginSms(Request $request){
        try {
            $rules = array(
                'mobile' => "required",
                'code' => "required",
            );
            $validator = Validator::make($request->all(),$rules);
            if($validator->fails()){
                return $validator->errors();
            }
        // $response = Msg91::sms()
        // ->to([918800903707]) // set the mobiles with country code
        // ->flow("605cb9b0df920e39d20f4815") // set the flow id
        // ->variable('OTP', "914572") // the the value for variable "date" in your flow message template
        // ->send(); // send

        //sms TEm OTP
      
        //Verify
            $mobile = $request->input('code') . $request->input('mobile');
            $user = User::where('mobile', $mobile)->first();
            if(empty($user)){
                $user = new User;
                $user->mobile = $mobile;
                $user->status = 'active';
                $user->is_new = 'yes';
                $user->save();
                $user = User::where('mobile', $mobile)->first();
            }
            $response = Msg91::otp()
            ->to($mobile) // phone number with country code
            ->template('602d4f66418adf304548759f') // set the otp template
            ->send(); // send the otp
            if($response->getStatusCode() == 200){
                return response()->json([
                    'user' => $user,
                    'code' => 200,
                    "status" => true,
                    'message' =>  "Sms Sent Successfully.",
                ]);
            }
            // $response = Msg91::otp(7951) // OTP to be verified
            //         ->to(918800903707) // phone number with country code
            //         ->verify(); // Verify
                    // response data
            // return $response->getData();
            // response message
            // return $response->getMessage();
            // response status code
            // return $response->getStatusCode();
        } catch (\Craftsys\Msg91\Exceptions\ValidationException $e) {
            return response()->json([ 
                "code" => "203",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // issue with the request e.g. token not provided
        } catch (\Craftsys\Msg91\Exceptions\ResponseErrorException $e) {
            return response()->json([ 
                "code" => "204",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // error thrown by msg91 apis or by http client
        } catch (\Exception $e) {
            return response()->json([ 
                "code" => "205",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // something else went wrong
            // plese report if this happens :)
        }
        return json_encode($response);
    }
    function verifySms(Request $request){
        $rules = array(
            'mobile' => "required",
            'code' => "required",
            'otp' => "required|digits:4",
        );
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
            return $validator->errors();
        }
        $mobile = $request->input('code') . $request->input('mobile');
        $user = User::where('mobile', $mobile)->first();
        if(empty($user)){
            return response()->json([
                'user' => new \StdClass(),
                'code' => 100,
                "status" => true,
                'message' =>  "unable to find user.",
            ]);
        }
        try {
            $response = Msg91::otp(intVal($request->input('otp'))) // OTP to be verified
                ->to($mobile) // phone number with country code
                ->verify(); // Verify
                
            // return response()->json([ $response->getData()]);
            return response()->json([ 
                "code" => "200",
                "status" => true,
                "message" => $response->getMessage()]
            );
        } catch (\Craftsys\Msg91\Exceptions\ValidationException $e) {
            return response()->json([ 
                "code" => "202",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // issue with the request e.g. token not provided
        } catch (\Craftsys\Msg91\Exceptions\ResponseErrorException $e) {
            return response()->json([ 
                "code" => "205",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // error thrown by msg91 apis or by http client
        } catch (\Exception $e) {
            return response()->json([ 
                "code" => "204",
                "status" => true,
                "message" => $e->getMessage()]
            );
            // something else went wrong
            // plese report if this happens :)
        }
    }
}
